#ifndef _DORECEIVE_CPP
#define _DORECEIVE_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define WIN32_LEAN_AND_MEAN
#define _WIN32_WINNT 0x0500

#include <Windows.H>
#include <WinSock2.H>
#include <WinSock.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <IOStream>

#include "SockServer.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool SocketServer::DoRecv(int iClient)
{
    #ifdef _DEBUG_SOCK_SERVER
    printf("DEBUG: [In Proc]> SocketServer::DoRecv.\n");
    #endif

	if(icRecvBufSz[iClient] > MAXRECVSIZE)
	{
		return false;
	}

    char sLocalRecvBuf[MAXRECVSIZE + 1];
    int iResult = 0;

	if((iResult = recv(sckcSocket[iClient], sLocalRecvBuf, MAXRECVSIZE, 0)) == SOCKET_ERROR)
	{
		bcDisconnect[iClient] = true;
		return false;
	}
	else if(iResult == 0) // Gracefull disconnect
	{
		bcDisconnect[iClient] = true;
		return false;
	}

    icRecvOffset[iClient] = 0;

    if(bcConnected[iClient] && !bcDisconnect[iClient])
    {
		if(icRecvBufSz[iClient] == 0)
		{
			memcpy(scRecvBuf[iClient], sLocalRecvBuf, iResult);
	        icRecvBufSz[iClient] = iResult;
		}
		else{
			int iRPos = 0;
			int iWPos = icRecvBufSz[iClient];

			while(iRPos < iResult)
			{
				scRecvBuf[iClient][iWPos] = sLocalRecvBuf[iRPos];
				iRPos++;
				iWPos++;
			}
			icRecvBufSz[iClient] = (icRecvBufSz[iClient] + iResult);
		}
	}
    else return false;

    return true;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

